;;
;;;
;;;    GETSEL.LSP
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
(defun c:GETSEL (/ LAY    ;; Layer of the selected entity
                   ENT    ;; Entity type of seleted entity
                   SS     ;; Selection set
                   SSLST  ;; Filter list
                   cspace ;; current space
                )
 
  (acet-error-init
         (list
           (list "cmdecho" 0
                 "expert"  0
           )
           T     ;flag. True means use undo for error clean up.
         )       ;list
  );acet-error-init
  (sssetfirst nil nil)
 
  ;;(setq LAY (car(entsel "\nSelect Object on layer to Select from <*>: ")))
  (setq LAY (car (entsel "\nSelect an object on the Source layer <*>: ")))
 
  (if LAY
    (setq LAY  (cdr(assoc 8 (entget LAY)))
          SSLST (list (cons 8 LAY ))
    )
  )
 
  ;;(setq ENT (car(entsel "\nSelect type of entity you want <*>: ")))
  (setq ENT (car(entsel "\nSelect an object of the Type you want <*>: ")))
 
  (if ENT
    (progn
      (setq ENT  (cdr(assoc 0 (entget ENT))))
      (if SSLST
         (setq SSLST (append (list (cons 0 ENT )) SSLST))
         (setq SSLST (list (cons 0 ENT )))
      )
    )
  )
  (if SSLST
    (progn
      (cond
        ((and LAY ENT)
          (prompt (acet-str-format "\nCollecting all %1 objects on layer %2..." ENT LAY))
        )
        (LAY
          (prompt (acet-str-format "\nCollecting ALL objects on layer %1..."  LAY ))
        )
        (ENT
          (prompt (acet-str-format "\nCollecting all %1 objects in the drawing..."  ENT ))
        )
        (T
          (prompt "\nCollecting all objects in the drawing...")
        )
      )
      (setq SS (ssget "_X" SSLST))
    )
    (progn
      (setq SS (ssget "_X"))
    ) ;progn
  )
  (if SS
    (progn
      (setq SS (sslength SS))
      (if (> SS 0)
        (if (= SS 1)
          (prompt
            (acet-str-format "\n%1 object has been placed in the active selection set." (itoa SS))
          )
          (prompt
            (acet-str-format "\n%1 objects have been placed in the active selection set." (itoa SS))
          )
        ) ;if
        (prompt"\nNothing selected.")
      )
    ) ;progn
  ) ;if
 
  (acet-error-restore)
 
  (princ)
 
);end defun


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; cQcAADCCB20GCSqGSIb3DQEHAqCCB14wggdaAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBzCCBQMwggProAMCAQICEHZytCYU0up+ZBBTpYM4hJYw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTYwODA4MDAwMDAwWhcNMTcwOTAyMjM1OTU5WjCBiDELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FjAUBgNVBAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlv
;;; bnMgR3JvdXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEB
;;; AQUAA4IBDwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl
;;; 95fnZY3sOEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYR
;;; lKvAbe2n+VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVg
;;; CIL/iPRNIuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQ
;;; k6EdROwqesgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7h
;;; HzQpLaLFJRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFpMIIBZTAJ
;;; BgNVHRMEAjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBh
;;; BgNVHSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdodHRwczovL2Quc3lt
;;; Y2IuY29tL2NwczAlBggrBgEFBQcCAjAZDBdodHRwczovL2Quc3ltY2IuY29tL3Jw
;;; YTAfBgNVHSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNVHR8EJDAiMCCg
;;; HqAchhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNybDBXBggrBgEFBQcBAQRLMEkw
;;; HwYIKwYBBQUHMAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUHMAKGGmh0
;;; dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MBEGCWCGSAGG+EIBAQQEAwIEEDAWBgor
;;; BgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0BAQsFAAOCAQEAwDtvZOfelquc
;;; pqTk6GC5mkXO2Xhr2Meo+ZTVpsAgvQAi0zfpqlxdZrH+SrR0R06cixVQx/8wgty6
;;; 0cx0h7n5YZChZYSULBLbWd64ZisZRLSfOSHfaQPMJlzfkObSiErUXli7GdngNeRv
;;; QRBZj76uQwBY9IfizReoavOwtm1aoptvSn/cAzKdzXXe4Y9O0BFYewqgihKACWL1
;;; 0QQQHazE6owk7WAsA5AGgIOS3RJucO+owkJEdl8yjk4A5amvbkCMkAQHNnIul/Tg
;;; XRicNGTNCQ5RJEaa97jg7WSDp1EEHISPpPnMBACu/rxYX7CwYuw8rdZm73yDa/NN
;;; 3BY2t4uSTjGCAiowggImAgEBMIGZMIGEMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
;;; U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
;;; dHdvcmsxNTAzBgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
;;; bmluZyBDQSAtIEcyAhB2crQmFNLqfmQQU6WDOISWMA0GCSqGSIb3DQEBCwUAMA0G
;;; CSqGSIb3DQEBAQUABIIBAGW2QbjKgaPmg6bBZhBnDCD5aeqzWNPCF1B55soI87XG
;;; y795KwUStStnvpkdcIQk4vAoR8yvQfij9CZaIfBE2npSYLybdOa7O3RNWR7X8HJU
;;; HmcWXT6zFpZe0dZA5j2TWuhkr8zkx7qjZ5GTLP6cD/HZHrw8DG3qGdPwNEVIXjDX
;;; qisuN4wDyQC+/O7V2tcZkxwtBV9OE3pKjADZHIf1djWV/H7H1TaWUw4vuRz38+VD
;;; 3GlYRmk7qPDC08nV0L1UxAHy4LQqIlg9DxAf0hvwXDzRmAWksnwe/hjYiJEPfK5Q
;;; A8AaEPRAzmqwpr4PqZy1bH0poUL1cDOm/FBDtdvFmNKhYzBhBgNVHQ4xWgRYNAAw
;;; ADsAMgAvADMALwAyADAAMQA3AC8ANAAvADUAMAAvADQAMAAvAFQAaQBtAGUAIABm
;;; AHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----